package gov.va.med.mhv.phr.allergy.model;

import org.displaytag.decorator.TableDecorator;

/**
 * Defines the order in which allergy views are ordered.
 * @author                   
 */
public class AllergyRowSorter extends MultiPropertyRowSorter {

    private static final SortOrder[] SORT_ORDER = {
        new SortOrder("collectedOn", false),
        new SortOrder("reactant", true),
        new SortOrder("allergyReaction", true),
        new SortOrder("facilityName", true),
        new SortOrder("allergySource", true)
    };

    public AllergyRowSorter(String propertyName, TableDecorator tableDecorator,
        boolean isAscending)
    {
        super(propertyName, tableDecorator, isAscending);
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.pharmacy.model.MultiplePropertySorter#getSortOrder()
     */
    @Override
    protected SortOrder[] getSortOrder()
    {
        return SORT_ORDER;
    }

}
